#include <iostream>
#include <format>

class Person {
// Access control - private
private:
    std::string firstName;
    std::string lastName;
// Access control - public
public:
    // Constructor with first name and last name
    Person(const std::string& fName, const std::string& lName)
        : firstName(fName), lastName(lName) {
    }
    // Overloaded constructor with last name only
    Person(const std::string& lName)
        :lastName(lName) {
        setFirstName("");
    }
    // Default constructor no parameters
    Person() {
        setFirstName("");
        setLastName("");
    }

    // Getters
    std::string getFirstName() const { return firstName; }
    std::string getLastName() const { return lastName; }

    // Setters
    void setFirstName(const std::string& fName) { firstName = fName; }
    void setLastName(const std::string& lName) { lastName = lName; }

    // Destructor
    ~Person() { }

    // overload == operator
    bool operator==(Person& anotherPerson) {
        return (firstName == anotherPerson.firstName && lastName == anotherPerson.lastName);
    }
};

int main() {
    // create a Person with first name and last name
    Person person("Joe", "Smith");
    std::cout << std::format("The person is {} {}.\n", person.getFirstName(), person.getLastName());
    // create a Person using last name constructor
    Person person2("Gilmour");
    person2.setFirstName("David");   // call setter to set first name
    std::cout << std::format("The person created with last name constructor is {} {}.\n", person2.getFirstName(), person2.getLastName());
    // create a person using default constructor
    Person person3;
    person3.setFirstName("Misty");   // call setter to set first name
    person3.setLastName("Autumn");    // call setter to set last name
    std::cout << std::format("The person created with default constructor is {} {}.\n", person3.getFirstName(), person3.getLastName());
    // create a duplicate person 
    Person duplicatePerson("Joe", "Smith");
    std::cout << "\n==== Duplicate Person check ====\n";
    if (person == duplicatePerson) {
        std::cout << "Persons are the same!\n";
    }
    else {
        std::cout << "Persons are NOT the same!\n";
    }
}
