#include <iostream>
#include <array>

int main() {
    std::array<int, 5> myInts10 = { 10, 20, 30, 40, 50 };
    std::array<int, 5> myInts100 = { 100, 200, 300, 400, 500 };

    // Get raw pointers to the start of each array
    int* arrayPtr10 = myInts10.data();
    int* arrayPtr100 = myInts100.data();

    // Loop through both arrays using pointer arithmetic
    for (size_t i = 0; i < myInts10.size(); ++i) {

        // Print current values
        std::cout << "myInts10 current value: " << *(arrayPtr10 + i) << "\n";
        std::cout << "myInts100 value: " << *(arrayPtr100 + i) << "\n";

        // Modify myInts10 by adding the corresponding myInts100 element
        *(arrayPtr10 + i) += *(arrayPtr100 + i);

        // Print the updated value
        std::cout << "myInts10 new value: " << *(arrayPtr10 + i) << "\n";
    }

    return 0;
}
