#include <iostream>

int main() {
    int score = 10;
    int bonus = 5;

    // REFERENCE
    int& r = score;    // Must be initialized
    int* p = nullptr;  // Pointers can be initialized to null

    int* heapPtr = new int(100); 
    std::cout << "--- Initial Values ---\n";
    std::cout << "Score: " << score << "\n";
    std::cout << "Ref (r): " << r << "\n";
    std::cout << "Ptr (*p): Ptr is null\n"; // Cannot safely dereference p yet
    std::cout << "Heap Ptr (*heapPtr): " << *heapPtr << "\n\n";

    // 1. ACCESS & MODIFICATION 

    r = 15;  // Reference
    p = &bonus; 
    *p = 50;   // Pointer (Requires *)
    std::cout << "--- Access & Modification ---\n";
    std::cout << "Score (via ref): " << score << "\n"; 
    std::cout << "Bonus (via ptr): " << bonus << "\n\n";

    // --- 2. REASSIGNMENT ---
    int anotherScore = 200;

    // Pointers can change targets
    p = &anotherScore;
    std::cout << "Ptr reassigned to anotherScore: " << *p << "\n"; 

    // References cannot change targets
    r = anotherScore;
    std::cout << "Score after 'reassignment' attempt: " << score << "\n\n"; 

    // Cleanup
    delete heapPtr;
    heapPtr = nullptr;
    
    std::cout<<"End of Demo!";
    return 0;
}