#include <iostream>
#include <memory>
#include <string>

int main() {
    // 1. unique_ptr (Exclusive Ownership)
    std::cout << "--- unique_ptr Demo ---\n";
    // Allocation: Memory is automatically deleted when uniquePtr goes out of scope.
    std::unique_ptr<std::string> uniquePtr = std::make_unique<std::string>("Unique String Data");
    std::cout << "unique_ptr value: " << *uniquePtr << "\n\n";

    // 2. shared_ptr (Shared Ownership)
    std::cout << "--- shared_ptr Demo ---\n";
    // RC = 1
    std::shared_ptr<int> sharedPtr1 = std::make_shared<int>(150); 
    std::cout << "sharedPtr1 RC: " << sharedPtr1.use_count() << "\n";

    // RC = 2 (Both pointers own the memory)
    std::shared_ptr<int> sharedPtr2 = sharedPtr1; 
    std::cout << "sharedPtr2 created. RC is now: " << sharedPtr1.use_count() << "\n\n";

    // 3. weak_ptr (Non-Owning Reference)
    std::cout << "--- weak_ptr Demo ---\n";
    // weakPtr observes sharedPtr1, but RC remains 2.
    std::weak_ptr<int> weakPtr = sharedPtr1; 
    
    // Temporarily convert weakPtr to a shared_ptr to access the value
    if (auto tempPtr = weakPtr.lock()) {
        std::cout << "weak_ptr successfully locked. Value: " << *tempPtr << "\n";
    } else {
        std::cout << "weak_ptr target object was destroyed.\n";
    }
    std::cout << "\nEnd of Demo!";
    // When main ends, sharedPtr1 and sharedPtr2 are destroyed, RC drops to 0, and memory is freed.
    
    return 0;
}