#include <iostream>
#include <string>

int main() 
{

    // 1. Address-of operator (&) and Basic Variable
    std::string myString = "My C++ String";
    std::cout << "--- Address & Value Check ---\n";
    std::cout << "Value of myString: " << myString << "\n";  
    std::cout << "Address of myString (&myString): " << &myString << "\n\n";  // Use & to get memory address


    // 2. Creating, Initializing, and Using a Pointer
    int myInt = 45;
    int* myIntPtr = &myInt;  // Declares an integer pointer and initialize with address of myInt
    std::cout << "--- Pointer Initialization ---\n";
    std::cout << "Original myInt value: " << myInt << "\n";
    std::cout << "Address stored in myIntPtr: " << myIntPtr << "\n\n";  // myIntPtr holds the address of myInt


    // 3. Dereferencing Pointers (*)
    std::cout << "--- Dereferencing ---\n";
    // Read the value using the dereference operator (*)
    std::cout << "Value using *myIntPtr (Dereferenced): " << *myIntPtr << "\n"; 
    // Change the value of the original variable (myInt) using the pointer
    *myIntPtr = 99;
    std::cout << "myInt value after being changed via pointer: " << myInt << "\n";
    std::cout << "Value using *myIntPtr after changing: " << *myIntPtr << "\n\n"; 


    // 4. Address Persistence Check
    std::string checkString = "Verify Address";
    std::cout << "--- Address Persistence ---\n";
    // Get the initial address
    std::cout << "Original address: " << &checkString << "\n";
    // Change the value
    checkString = "Address Stays Same";
    // Check the address again; it should be the same
    std::cout << "Address after change: " << &checkString << "\n\n";
    

    // 5. Null Pointer Example
    std::cout << "--- Null Pointer Example ---\n";
    // Initialize a pointer to nullptr
    int* safePtr = nullptr; 
    std::cout << "The value of nullptr is: " << safePtr << "\n";
    
    // Assign a valid address
    int data = 100;
    safePtr = &data;
    std::cout << "The value of nullptr after assignment is: " << safePtr << "\n";
    std::cout << "The value it points to is: " << *safePtr << "\n\n";
    std::cout<<"End of Demo!";
    return 0;
}