#include <iostream>
#include <array>

int main() {

    std::array<int, 5> nums = {1, 2, 3, 4, 5};

    // Start pointer at first element
    int* ptr = nums.data();
    std::cout << "First value: " << *ptr << "\n";

    // (pointer arithmetic)
    ++ptr;   // Move pointer to next element
    std::cout << "Second value (after ++ptr): " << *ptr << "\n";

    // Move two steps ahead
    ptr += 2;  
    std::cout << "Fourth value (after ptr += 2): " << *ptr << "\n";

    // Move pointer one step back 
    ptr--;  
    std::cout << "Third value (after ptr--): " << *ptr << "\n\n";


    // Loop using pointer arithmetic
    std::cout << "Iterating with pointer arithmetic:\n";
    for (ptr = nums.data(); ptr < nums.data() + nums.size(); ++ptr) {
        std::cout << *ptr << " ";
    }
    std::cout << "\n\n";


    // Demonstrating bounds
    std::cout << "Valid positions:\n";
    for (size_t i = 0; i < nums.size(); ++i) 
    {
        std::cout << "*(nums.data() + " << i << ") = " << *(nums.data() + i) << "\n";
    }
    std::cout << "\nAvoid doing this (out of bounds): *(nums.data() + 10)\n";
    std::cout << " this will generate undefined behavior \n\n";
    std::cout << "End of Demo!";

    return 0;
}
