// MemoryAndPointers.cpp 
//

#include <iostream>
#include <array>

int main() {
    int myInt = 45;
    // set up a pointer variable to myInt:
    int* myIntPtr = &myInt;
    // print variable value and address:
    std::cout << "myInt value: " << myInt << " address is " << myIntPtr << ".\n";
    std::string myString = "My String Variable";
    std::cout << myString << "\n";
    std::cout << "The address of myString is " << &myString << "\n";
    std::cout << "Dereferencing the address of myString is " << *&myString << "\n";
    // change the value:
    myString = "Changed value";
    std::cout << "The address of myString after change is " << &myString << "\n";
    std::string* myStringPtr;
    myStringPtr = &myString;
    std::cout << "The address of myString using another pointer is " << myStringPtr << "\n";
    std::cout << "Dereferencing another pointer is " << *myStringPtr << "\n";

    // pointer arithmetic
    std::array<int, 5> myInts = { 1, 2, 3, 4,5 };
    int* arrayPtr = myInts.data();
    std::cout << "First item in the array: " << *arrayPtr << "\n";
    std::cout << "Second item in the array: " << *++arrayPtr << "\n";
    std::cout << "size is: " << myInts.size() << "\n";
    std::cout << "Iterate through the array using pointer arithmetic: \n";
    for (arrayPtr = myInts.data(); arrayPtr < myInts.data() + myInts.size(); ++arrayPtr) {
        std::cout << *arrayPtr << " ";
    }
    std::cout << "\n";

    // dynamic allocation and deallocation of memory
    std::string* myNameDynamic = new std::string("Stephen Withrow");
    std::cout << "My name allocated from dynamic memory: " << *myNameDynamic << "\n";
    delete myNameDynamic;
    // reference vs. pointer
    // define "myName" as a reference
    std::string myNameReference = "Stephen Withrow";
    std::cout << "My name as a reference variable: " << myNameReference << "\n";
    // define "myNamePointer" as a pointer
    std::string* myNamePointer = new std::string("Stephen Withrow");
    std::cout << "My name as a pointer: " << *myNamePointer << "\n";

}


