#include <iostream>

// Base Class
class Vehicle {
public:
    Vehicle() {
        std::cout << "Vehicle: standard features initialized\n";
    }
};

// Single Inheritance
// Car inherits from Vehicle
class Car : public Vehicle {
public:
    Car() {
        std::cout << "Car: ready for road use\n";
    }
};

// Multilevel Inheritance
// SportsCar inherits from Car (Car already inherits Vehicle)
class SportsCar : public Car {
public:
    SportsCar() {
        std::cout << "SportsCar: high performance enabled\n";
    }
};

// Hierarchical Inheritance
// Multiple classes inherit from the same base class Vehicle
class ElectricCar : public Vehicle {
public:
    ElectricCar() {
        std::cout << "ElectricCar: battery powered system ready\n";
    }
};

// Multiple Inheritance
// Two independent base classes
class FuelSystem {
public:
    FuelSystem() {
        std::cout << "FuelSystem: fuel engine initialized\n";
    }
};

class ElectricSystem {
public:
    ElectricSystem() {
        std::cout << "ElectricSystem: electric motor initialized\n";
    }
};

// HybridEngine inherits from two unrelated classes
class HybridEngine : public FuelSystem, public ElectricSystem {
public:
    HybridEngine() {
        std::cout << "HybridEngine: combines fuel and electric power\n";
    }
};

// Hybrid Inheritance
// Combination of hierarchical + multiple inheritance
class HybridCar : public Car, public ElectricCar {
public:
    HybridCar() {
        std::cout << "HybridCar: comfort + eco-friendly driving\n";
    }
};

// Main Function
int main() {

    std::cout << "--- Single Inheritance ---\n";
    // Vehicle -> Car
    Car c;

    std::cout << "\n--- Multilevel Inheritance ---\n";
    // Vehicle -> Car -> SportsCar
    SportsCar sc;

    std::cout << "\n--- Hierarchical Inheritance ---\n";
    // Vehicle -> ElectricCar
    ElectricCar ec;

    std::cout << "\n--- Multiple Inheritance ---\n";
    // FuelSystem + ElectricSystem -> HybridEngine
    HybridEngine he;

    std::cout << "\n--- Hybrid Inheritance ---\n";
    // Vehicle -> Car and Vehicle -> ElectricCar -> HybridCar
    HybridCar hc;

    return 0;
}