#include <iostream>

// Base Class
class Vehicle {
public:
    Vehicle() {
        std::cout << "Vehicle: standard features initialized\n";
    }
};

// Car inherits from Vehicle
class Car : public Vehicle {
public:
    Car() {
        std::cout << "Car: ready for road use\n";
    }
};

// Multilevel Inheritance
// SportsCar inherits from Car (Car already inherits Vehicle)
class SportsCar : public Car {
public:
    SportsCar() {
        std::cout << "SportsCar: high performance enabled\n";
    }
};

class Aircraft {
public:
    Aircraft() {
        std::cout << "Aircraft for flight\n";
    }
};

// Multiple Inheritance
// FlyingCar Is a Vehicle AND Is an Aircraft
class FlyingCar : public Vehicle, public Aircraft {
public:
    FlyingCar() {
        std::cout << "FlyingCar can drive and fly\n";
    }
};


// Main Function
int main() {

    // Vehicle -> Car
    std::cout << "---  Create a Car ---\n";
    Car c;

    std::cout << "\n--- Create a SportsCar ---\n";
    // Vehicle -> Car -> SportsCar
    SportsCar sc;

    std::cout << "\n--- Create a FlyingCar ---\n";
    // Vehicle and Aircraft -> FlyingCar
    FlyingCar fc;

    return 0;
}