#include <iostream>
#include <format>
#include <stdexcept>
#include <string>

const double START_BALANCE = 0.0;
double balance = START_BALANCE;
std::string userInput;

double withdraw(double amount) {
    static int nbrOfWithdrawals = 1;
    if (amount > balance) {
        std::string error_msg = std::format("Withdrawal rejected: amount {:.2f} exceeds balance.\n", amount);
        throw std::runtime_error(error_msg);
    }
    else if (amount <= 0) {
        std::string error_msg = std::format("Withdrawal rejected: amount {:.2f} is less than or equal to zero.\n", amount);
        throw std::runtime_error(error_msg);
    }
    else {
        std::cout << std::format("Number of withdrawals is now {}\n", nbrOfWithdrawals);
        if (nbrOfWithdrawals > 3) {
            amount += 3;
        }
        nbrOfWithdrawals++;
        return balance -= amount;
    }
}

double deposit(double amount) {
    if (amount <= 0) {
        std::string error_msg = std::format("Deposit rejected: amount {:.2f} is less than or equal to zero.\n", amount);
        throw std::runtime_error(error_msg);
    }
    else {
        return balance += amount;
    }
}

int main() {
    
    do {
        // Display menu options
        std::cout << "\n Deposit (d)\n";
        std::cout << " Withdraw (w)\n";
        std::cout << " Balance (b)\n";
        std::cout << " Quit (q)\n\n";
        std::cout << "Enter choice: ";
        std::getline(std::cin, userInput);

        if (userInput.empty()) continue;  // ignore blank lines

        switch (userInput[0]) {
            // Handle deposit
            case 'd':
            case 'D': {
                double amount;
                std::cout << "Enter amount to deposit: ";
                std::getline(std::cin, userInput);
                try {
                    amount = std::stod(userInput);
                    balance = deposit(amount);
                    std::cout << std::format("Deposited ${:.2f}\n", amount);
                }
                catch (std::invalid_argument& ia) {
                   std::cout <<  "Deposit amount must be numeric, amount rejected.\n";
                }
                catch (std::runtime_error& re) {
                   std::cout << re.what();
                }
                break;
            }
            // Handle withdrawal
            case 'w':
            case 'W': {
                double amount;
                std::cout << "Enter withdrawal amount: ";
                std::getline(std::cin, userInput);
                try {
                    amount = std::stod(userInput);
                    balance = withdraw(amount);
                }
                catch (std::invalid_argument& ia) {
                   std::cout <<  "Withdrawal amount must be numeric, amount rejected.\n";
                }
                catch (std::runtime_error& rte) {
                    std::cout << rte.what();
                }    
                break;
            }
            // Display balance
            case 'b':
            case 'B':
                std::cout << std::format("Current balance: ${:.2f}\n", balance);
                break;
            // Handle quit
            case 'q':
            case 'Q':
                std::cout << std::format("Final balance: ${:.2f}\n", balance);
                break;
            // Handle invalid input
            default:
                std::cout << "Invalid selection. Please choose a valid option.\n";
        }

    } while (userInput[0] != 'q' && userInput[0] != 'Q');

    return 0;
}
