#include <iostream>
#include <format>
#include <string>

int main() {
    const double START_BALANCE = 0.0; // Initial account balance
    double balance = START_BALANCE;   // User's account balance
    std::string userInput;            // User's menu choice

    do {
        // Display menu options
        std::cout << "\n Deposit (d)\n";
        std::cout << " Withdraw (w)\n";
        std::cout << " Balance (b)\n";
        std::cout << " Quit (q)\n\n";
        std::cout << "Enter choice: ";
        std::getline(std::cin, userInput);

        if (userInput.empty()) continue;  // ignore blank lines

        switch (userInput[0]) {
            // Handle deposit
            case 'd':
            case 'D': {
                double amount;
                std::cout << "Enter deposit amount: ";
                std::getline(std::cin, userInput);
                amount = std::stod(userInput);

                // Use while loop for validation
                while (amount <= 0) {
                    std::cout << "Amount must be positive. Try again: ";
                    std::getline(std::cin, userInput);
                    amount = std::stod(userInput);
                }

                balance += amount;
                std::cout << std::format("Deposited ${:.2f}\n", amount);
                break;
            }
            // Handle withdrawal
            case 'w':
            case 'W': {
                double amount;
                std::cout << "Enter withdrawal amount: ";
                std::getline(std::cin, userInput);
                amount = std::stod(userInput);

                while (amount <= 0) {
                    std::cout << "Amount must be positive. Try again: ";
                    std::getline(std::cin, userInput);
                    amount = std::stod(userInput);
                }

                if (amount > balance) {
                    std::cout << "Insufficient funds. Withdrawal denied.\n";
                } else {
                    balance -= amount;
                    std::cout << std::format("Withdrew ${:.2f}\n", amount);
                }
                break;
            }
            // Display balance
            case 'b':
            case 'B':
                std::cout << std::format("Current balance: ${:.2f}\n", balance);
                break;
            // Handle quit
            case 'q':
            case 'Q':
                std::cout << std::format("Final balance: ${:.2f}\n", balance);
                break;
            // Handle invalid input
            default:
                std::cout << "Invalid selection. Please choose a valid option.\n";
        }

    } while (userInput[0] != 'q' && userInput[0] != 'Q');

    return 0;
}
