#include <iostream>

// consteval example
// This function MUST run at compile time.
consteval int triple(int x) {
    return x * 3;
}

// constexpr example
// This function CAN run at compile time, but can also run at runtime.
constexpr int square(int x) {
    return x * x;
}

int main() {
    // consteval usage
    int i = triple(6);
    std::cout << "triple(6) = " << i << " (consteval computed at compile time)\n";
    const int I = 6;
    i = triple(I);
    std::cout << "triple(I) = " << i << " (consteval computed at compile time using a constant)\n";

    //int r;
    //i = triple(r);        // ERROR: triple must run at compile time. Uncommenting this will fail to compile.
                                 
    // call constexpr function with a literal
    int j = square(7); 
    std::cout << "square(7) = " << j << " (constexpr computed at compile time)\n";
    // call constexpr function with a constant
    const int J = 7;
    j = square(J);
    std::cout << "square(J) = " << j << " (constexpr computed at compile time using a constant)\n";
    // call constexpr function with a variable
    int y = 7;
    int k = square(y);           // pass a variable to the function
    std::cout << "square(y) = " << k << " (constexpr computed at runtime)\n";

    return 0;
}