#include <iostream>

// Global scope & lifetime
// Exists for the entire program
int globalCount = 0;

// Namespace scope
namespace Config {
    int version = 1;
}

// Function demonstrating local & static variables
void demoFunction() {
    int localVar = 10;          // local scope, destroyed each time
    static int staticVar = 0;   // static lifetime, keeps value between calls
    
    staticVar++; // remembers previous value
    std::cout << "localVar: " << localVar << "\n";
    std::cout << "staticVar: " << staticVar << "\n";
}

int main() {

    // Local scope
    int x = 5;   // exists only inside main()
    std::cout << "x: " << x << "\n";


    // Block scope
    if (true) {
        int y = 20; // exists only inside this block
        std::cout << "y inside block: " << y << "\n";
    }
    // y is not accessible here
    
    // Using global variable
    globalCount++;
    std::cout << "globalCount: " << globalCount << "\n";
  
    // Namespace variable
    std::cout << "Config::version: " << Config::version << "\n";
    
    // Demonstrate local vs static lifetime
    demoFunction();
    demoFunction();
    demoFunction(); // staticVar keeps increasing

    return 0;
}