#include <iostream>
#include <string>


// Function Overloading
// Same name, different parameters
void show(int number) {
std::cout << "You passed an integer: " << number << "\n";
}

void show(const std::string& text) {
std::cout << "You passed a string: " << text << "\n";
}

// Default Parameter
// If 'name' is not provided, "Guest" is used
void greet(std::string name = "Guest") {
std::cout << "Hello, " << name << "!\n";
}

int main() {

    // --- Overloading examples ---
    show(42);            // calls the int version
    show("Hello");       // calls the string version

    // --- Default parameter examples ---
    greet("Alice");      // uses provided argument
    greet();             // uses default "Guest"

    return 0;
}