#include <iostream>

// Generic function (template)
// Works with any type T and any callable F

template <typename T, typename F>
void apply(T value, F func) {
std::cout << "Result: " << func(value) << "\n";
}

int main() {
    
    // Basic lambda
    auto add = [](int a, int b) {
        return a + b;
    };

    std::cout << "add(3, 5) = " << add(3, 5) << "\n";
    
    // Lambda with capture
    int factor = 2;

    auto multiply = [factor](int x) {   // captures factor by value
        return x * factor;
    };

    std::cout << "multiply(10) = " << multiply(10) << "\n";

    // Using a lambda with a generic function
    apply(5, [](int x) { return x * 3; });   // prints 15

    return 0;
}