#include <iostream>

// Function declarations
int add(int a, int b);              // returns a value
void addOneByValue(int n);          // gets a copy
void addOneByReference(int& n);     // works on the original variable

// Function definitions
int add(int a, int b) {
    return a + b;   // send a value back to the caller
}

void addOneByValue(int n) {         // n = copy of caller's variable
    n = n + 1;                      // only the copy is changed
}

void addOneByReference(int& n) {    // n refers to caller's variable
    n = n + 1;                      // original variable changes
}

int main() {

    // Calling a function with return value
    int sum = add(3, 4);
    std::cout << "add(3, 4) = " << sum << "\n";

    // Passing by value
    int a = 5;
    addOneByValue(a);               // a does NOT change
    std::cout << "After addOneByValue: " << a << "\n";

    // Passing by reference
    int b = 5;
    addOneByReference(b);           // b DOES change
    std::cout << "After addOneByReference: " << b << "\n";

    return 0;
}