#include <iostream>
#include <string>
#include <exception>

int main() {
    try {
        std::string text = "abc";   // not a number
        std::cout << "Trying to convert text to a number...\n";

        int number = std::stoi(text);   // may throw invalid_argument
        std::cout << "Number is: " << number << "\n";
    }
    catch (const std::invalid_argument& ex) {
        std::cout << "Invalid input! Cannot convert to number.\n";
        std::cout << "Message: " << ex.what() << "\n";
    }
    catch (...) {   // catches anything else
        std::cout << "An unknown error occurred.\n";
    }

    std::cout << "Program continues safely.\n";
    return 0;
}
