#include <iostream>   // For printing messages to the screen
#include <fstream>    // Needed for ofstream (output file stream)

int main() {

    // Step 1: Create an ofstream object and open the file. If the file does not exist, C++ will create it. If it DOES exist, its contents will be overwritten.
    std::ofstream file("output.txt");   // Opens/creates "output.txt"

    // Step 2: Always check if the file opened successfully.
    if (!file) {
        std::cout << "Error: Could not open file.\n";
        return 1;  // Exit the program with an error code
    }

    // Step 3: Write different types of data to the file. Writing works just like cout, but the text goes into the file.
    file << "Welcome to the ofstream demo!\n";
    file << "This file was created by C++.\n";

    int age = 25;
    file << "Your age is: " << age << "\n";  // Writing variables

    file << "Here are some numbers:\n";
    for (int i = 1; i <= 5; ++i) {
        file << i << " ";  // Write numbers on the same line
    }
    file << "\n";  // New line after the loop

    // Step 4: Close the file. This saves data and frees system resources.
    file.close();

    std::cout << "Data written to output.txt successfully!\n";

    return 0;
}