#include <iostream>
#include <fstream>

int main() {
    // Create an ifstream object and open "numbers.txt"
    std::ifstream inputFile("numbers.txt");

    // Check if the file was opened successfully
    if (!inputFile) {
        std::cout << "Error: Could not open file 'numbers.txt'.\n";
        return 1; // Exit the program if the file cannot be opened
    }

    int number; // Variable to store each number read from the file

    // Read numbers from the file one by one until the end of file
    while (inputFile >> number) {
        std::cout << "Number read: " << number << std::endl;
    }

    // Close the file when done
    inputFile.close();

    return 0;
}