#include <iostream>
#include <fstream>
#include <string>
#include <format>
#include "json.hpp"

using json = nlohmann::json;  // assign alias for the namespace to simplify coding

int main() {
    std::ifstream timeCard("TimeCard.json");
    if (!timeCard.is_open()) {
        std::cerr << "Error: Could not open employees.json\n";
        return 1;
    }

    json timeCardJSON;  // define the JSON object

    try {
        timeCard >> timeCardJSON;  // convert(parse) string data from file to JSON
    }
    catch (json::parse_error& pe) {
        std::cerr << "JSON Parse Error: " << pe.what() << '\n';
        return 1;
    }

    // Display the JSON file
    std::cout << "Raw JSON Input:\n";
    std::cout << timeCardJSON.dump() << "\n\n"; // dump JSON records to the console

    // Pretty output 
    std::cout << std::format("{:^20}{:^15}{:^15}\n", "Employee Name","Hours Worked", "Hourly Wage");
    for (const auto& tcj : timeCardJSON) {
        std::cout << std::format("{:<20}", tcj["EmployeeName"].get<std::string>())  
                  << std::format("{:>15}", tcj["HoursWorked"].get<int>())
                  << std::format("{:>15.2f}\n", tcj["HourlyWage"].get<float>());
    }

    return 0;
}