#include <iostream>
#include <fstream>  // use for ifstream
#include <sstream>  // use for stringstream
#include <string>   // use for getline
#include <format>
#include <iomanip>  // use to make float data pretty
 
int main() {
    // read records that have fixed fields:
    // employeeName positions 1:20
    // hoursWorked  positions 21:23
    // hourlyWage   positions 24:28
    std::ifstream timeCardDataFixed("TimeCardDataFixed.txt");
    if (!timeCardDataFixed) {
        std::cout << "Could not open file!";
    }
    std::string record;
    while (std::getline(timeCardDataFixed, record)) {
        std::string employeeName = record.substr(0, 20);
        int hoursWorked = std::stoi(record.substr(20,3));
        float hourlyWage = std::stof(record.substr(23, 5));
        std::cout << std::format("Name: {} Hours Worked: {} Wage: {}\n", employeeName, hoursWorked, hourlyWage);
        float netPay = hoursWorked * hourlyWage;
        std::cout << "Net pay: $" << std::fixed << std::setprecision(2) << netPay << "\n";
    }
    timeCardDataFixed.close();
    // uncomment the following lines to keep the console open 
    // for "externalConsole : true" in launch.json (Windows only)
    //std::cout << "Press enter to exit...\n";
    //std::cin.get();
}
