#include <iostream>
#include <format>
#include <fstream>   // use for ifstream
#include <sstream>   // use for stringstream to parse fields on one record
#include <string>

int main() {
    std::ifstream timeCard("TimeCard.txt");
    if (!timeCard.is_open()) {
        std::cout << "Cannot open file!";
        return 1;
    }
    std::string record;
    while (std::getline(timeCard, record)) {
        std::stringstream sStream(record);
        std::string employeeName, hoursWorkedStr, hourlyWageStr;
        // get employee name
        std::getline(sStream, employeeName, ','); // get data up to the first comma
        // remove quotation marks from employee name
        employeeName = employeeName.substr(1, employeeName.size() - 2);
        // get hours worked
        std::getline(sStream, hoursWorkedStr, ',');
        // get hourly wage
        std::getline(sStream, hourlyWageStr);
        // convert to numeric
        int hoursWorked = std::stoi(hoursWorkedStr);
        float hourlyWage = std::stof(hourlyWageStr);
        // print output
        std::string reportLine = std::format("{} worked {} hours at ${} per hour. Gross pay is ${}.\n",
            employeeName, hoursWorked, hourlyWage, hoursWorked* hourlyWage);
        std::cout << reportLine;
    }
    timeCard.close();
}