#include <iostream>
#include <fstream>   // for File I/O operations
#include <sstream>   // for getLine

int main() {
    // create an ofstream object and load file with hard-coded data:
    std::ofstream timeCardData("TimeCardData.txt");   // use this object to overwrite exising records
    //std::ofstream timeCardData("TimeCardData.txt", std::ios::app);   // std::ios::app will append records to file
    timeCardData << "\"Stephen Withrow\",40,25.00\n";
    timeCardData << "\"Jared Dunn\",42,27.00\n";
    timeCardData << "\"Cherie Burnett\",35,32.00\n";
    timeCardData << "\"Chris Smith\",40,42.00\n";
    timeCardData << "\"Justin Hayward\",32,30.00\n";
    timeCardData.close();

    // create ifstream object so we can read the file created above
    std::ifstream timeCard("TimeCardData.txt");
    if (!timeCard.is_open()) {
        std::cout << "Cannot open file!";
        return 1;
    }
    std::string record = "";
    std::cout << "Printing input file records..." << "\n";
    while (std::getline(timeCard, record)) {
        std::cout << record << "\n";
    }
   
    // we will read the Time Card file again 
    // and write each record to an output file
    timeCard.clear();   // clear the EOF switch
    timeCard.seekg(0);  // set g(et) pointer, i.e., rewind to the beginning of the file

    // open the output file in Input/Output mode and trunc (remove) any existing records
    std::fstream timeCardOUT("TimeCardOUT.text", std::ios::in | std::ios::out | std::ios::trunc);
    // use output mode to write records to the file
    while (std::getline(timeCard, record)) {
        timeCardOUT << record << "\n";
    }
    timeCardOUT.seekg(0);  // rewind the file
    // use input mode to verify records were written
    std::cout << "\nPrinting output file records..." << "\n";
    while (std::getline(timeCardOUT, record)) {
        std::cout << record << "\n";
    }
    timeCard.close();
    timeCardOUT.close();
}
