#include <iostream>
#include <string>

int main() {
    // --- Integer (int) ---
    int myInt = 45;                 // decimal (base 10)
    int binary15 = 0b1111;          // binary (base 2) => 15 in decimal
    int hex15 = 0xF;                // hexadecimal (base 16) => 15 in decimal

    // --- Long Integer (long long) ---
    long long myLongInt = 2147483648LL; // value too large for int, use LL for long long

    // --- Floating-Point Number (float) ---
    float myFloat = 3.4e37F;        // 3.4 × 10^37 (use f or F suffix for float)

    // --- Double-Precision Number (double) ---
    double myDouble = 3.4e40;       // larger range and precision than float
    double price = 19.99;           // default for decimals is double

    // --- Character (char) ---
    char grade = 'A';               // single character
    char symbol = '!';              // punctuation character
    char newline = '\n';            // special escape sequence (new line)

    // --- String (std::string) ---
    std::string myName = "Stephen";
    std::string greeting = "Hello, " + myName + "!";

    // --- Boolean (bool) ---
    bool isReady = true;            // true (1)
    bool isZero = 0;                // false (0)
    bool fromNum = 2025;            // true (nonzero converts to true)

    // --- Constants (const) ---
    const double PI = 3.14159;      // value cannot change after initialization
    const int MAX_RETRIES = 3;
    const float TAX_RATE = 0.07F;

    // --- Type Deduction (auto) ---
    auto myHomeTown = "Warner Robins"; // deduced as const char*
    auto year = 2025;                  // deduced as int
    auto bigNumber = 9'000'000'000LL;  // deduced as long long
    auto discountRate = 0.15;          // deduced as double

    // --- Reassignment Example ---
    std::cout << "Original myInt value: " << myInt << "\n";
    myInt = 100;                       // reassigning a new value to myInt
    std::cout << "Reassigned myInt value: " << myInt << "\n\n";

    // --- Constants Cannot Be Reassigned ---
    // The following examples would cause compile-time errors if uncommented:
    /*
    PI = 3.14;          // error: cannot modify a const variable
    TAX_RATE = 0.05F;   // error: cannot change value of constant
    */

    // --- Output all values ---
    std::cout << "Here are the values of the variables defined in this program:\n";
    std::cout << "int myInt: " << myInt << "\n";
    std::cout << "binary15 (0b1111): " << binary15 << "\n";
    std::cout << "hex15 (0xF): " << hex15 << "\n";
    std::cout << "long long myLongInt: " << myLongInt << "\n";
    std::cout << "myFloat: " << myFloat << "\n";
    std::cout << "myDouble: " << myDouble << "\n";
    std::cout << "price: " << price << "\n";
    std::cout << "char grade: " << grade << "\n";
    std::cout << "char symbol: " << symbol << "\n";
    std::cout << "myName: " << myName << "\n";
    std::cout << "greeting: " << greeting << "\n";
    std::cout << "bool isReady: " << isReady << "\n";
    std::cout << "bool isZero: " << isZero << "\n";
    std::cout << "bool fromNum: " << fromNum << "\n";
    std::cout << "PI (constant): " << PI << "\n";
    std::cout << "MAX_RETRIES (constant): " << MAX_RETRIES << "\n";
    std::cout << "TAX_RATE (constant): " << TAX_RATE << "\n";
    std::cout << "auto myHomeTown: " << myHomeTown << "\n";
    std::cout << "auto year: " << year << "\n";
    std::cout << "auto bigNumber: " << bigNumber << "\n";
    std::cout << "auto discountRate: " << discountRate << "\n";

    return 0;
}
