#include <iostream>
#include <string>

int main()
{
  std::cout << "=== Operators and Expressions Demo ===\n\n";

  // -------------------------------
  // Arithmetic Operators
  // -------------------------------
  int a = 7, b = 3;
  int sum = a + b;
  int diff = a - b;
  int prod = a * b;
  int quotInt = a / b; // integer division: decimals discarded
  int rem = a % b;     // remainder

  std::cout << "-- Arithmetic Operators --\n";
  std::cout << "a = " << a << ", b = " << b << "\n";
  std::cout << "a + b = " << sum << "\n";
  std::cout << "a - b = " << diff << "\n";
  std::cout << "a * b = " << prod << "\n";
  std::cout << "a / b (int division) = " << quotInt << "\n";
  std::cout << "a % b = " << rem << "\n";

  // -------------------------------
  // Increment and Decrement
  // -------------------------------
  int x = 5;
  int a1 = ++x; // pre-increment: x becomes 6, then a1 gets 6
  int a2 = x++; // post-increment: a2 gets 6, then x becomes 7

  std::cout << "-- Increment and Decrement --\n";
  std::cout << "After pre-increment (++x): a1 = " << a1 << ", x = " << x << "\n";
  std::cout << "After post-increment (x++): a2 = " << a2 << ", x = " << x << "\n\n";

  // -------------------------------
  // Assignment and Compound Assignment
  // -------------------------------
  int total = 10;
  total += 5; // same as total = total + 5
  total *= 2; // same as total = total * 2

  std::cout << "-- Assignment and Compound Assignment --\n";
  std::cout << "total = 10; total += 5; total *= 2;\n";
  std::cout << "Resulting total = " << total << "\n\n";

  // -------------------------------
  // Comparison Operators
  // -------------------------------
  int p = 5, q = 8;
  bool isLess = p < q;
  bool isEqual = p == q;

  std::cout << "-- Comparison Operators --\n";
  std::cout << "p = " << p << ", q = " << q << "\n";
  std::cout << "p < q: " << isLess << "\n";
  std::cout << "p == q: " << isEqual << "\n";
  std::cout << "p != q: " << (p != q) << "\n";
  std::cout << "p >= q: " << (p >= q) << "\n\n";

  // -------------------------------
  // Logical Operators
  // -------------------------------
  bool hasTicket = true;
  bool isGuest = false;
  bool canEnter = hasTicket || isGuest;
  bool needsCheck = hasTicket && !isGuest;

  std::cout << "-- Logical Operators --\n";
  std::cout << "hasTicket = " << hasTicket << ", isGuest = " << isGuest << "\n";
  std::cout << "hasTicket || isGuest = " << canEnter << "\n";
  std::cout << "hasTicket && !isGuest = " << needsCheck << "\n\n";

  // -------------------------------
  // Conditional (Ternary) Operator
  // -------------------------------
  int num1 = 5, num2 = 9;
  int max = (num1 > num2) ? num1 : num2;

  int evenTest = 4;
  std::string evenOrOdd = (evenTest % 2 == 0) ? "even" : "odd";

  std::cout << "-- Conditional (Ternary) Operator --\n";
  std::cout << "Between " << num1 << " and " << num2 << ", max = " << max << "\n";
  std::cout << evenTest << " is " << evenOrOdd << "\n\n";

  // -------------------------------
  // Operator Precedence and Parentheses
  // -------------------------------
  int n = 2 + 3 * 4;   // multiplication happens first
  int m = (2 + 3) * 4; // parentheses change order

  std::cout << "-- Operator Precedence and Parentheses --\n";
  std::cout << "2 + 3 * 4 = " << n << "\n";
  std::cout << "(2 + 3) * 4 = " << m << "\n\n";

  // -------------------------------
  // String Concatenation
  // -------------------------------
  std::string first = "Ada";
  std::string last = "Lovelace";
  std::string full = first + " " + last;

  std::cout << "-- Strings and the + Operator --\n";
  std::cout << "first: " << first << ", last: " << last << "\n";
  std::cout << "full = first + \" \" + last => " << full << "\n\n";

  // -------------------------------
  // Common Pitfalls
  // -------------------------------
  std::cout << "-- Common Pitfalls (demonstrations) --\n";
  int zero = 0;

  // Uncommenting this line would cause a runtime error (division by zero):
  // int badDiv = a / zero; // error: division by zero

  std::cout << "Always check the denominator before dividing.\n";
  std::cout << "Use parentheses to make your intent clear.\n";
  std::cout << "Avoid using ++ or -- multiple times in one expression.\n";

  std::cout << "\n=== End of Demo ===\n";

  return 0;
}
