#include <iostream>
#include <string>

int main() {
    // --- The for Loop ---
    std::cout << "--- for Loop ---\n";

    // Count from 1 to 5
    for (int i = 1; i <= 5; ++i) {
        std::cout << i << " ";
    }
    std::cout << "\n\n";

    // Count by 2s
    for (int i = 0; i < 10; i += 2) {
        std::cout << i << " ";
    }
    std::cout << "\n\n";

    // Summing numbers from 1 to n
    int n = 5;
    int sum = 0;
    for (int i = 1; i <= n; ++i) {
        sum += i;
    }
    std::cout << "Sum of 1..5 = " << sum << "\n\n";

    // Compare < vs <=
    for (int i = 0; i < 5; ++i) {
        std::cout << i << " ";
    }
    std::cout << "\n";
    for (int i = 0; i <= 5; ++i) {
        std::cout << i << " ";
    }
    std::cout << "\n\n";

    // --- The while Loop ---
    std::cout << "--- while Loop ---\n";

    int count = 5;
    while (count > 0) {
        std::cout << count << "\n";
        --count;
    }
    std::cout << "Liftoff!\n\n";

    // Input validation example
    int age = 0;
    std::cout << "Enter age (1..120): " << std::flush;
    std::cin >> age;

    while (age < 1 || age > 120) {
        std::cout << "Try again (1..120): " << std::flush;
        std::cin >> age;
    }
    std::cout << "Thanks! You entered " << age << ".\n\n";

    // --- The do-while Loop ---
    std::cout << "--- do-while Loop ---\n";

    char again = 'n';
    do {
        std::cout << "Performing an action...\n";
        std::cout << "Run again? (y/n): " << std::flush;
        std::cin >> again;
    } while (again == 'y' || again == 'Y');

    std::cout << "Done.\n\n";

    // --- Stopping or Skipping: break and continue ---
    std::cout << "--- break and continue ---\n";

    // Find the first multiple of 7
    for (int i = 1; i <= 100; ++i) {
        if (i % 7 == 0) {
            std::cout << "First multiple of 7: " << i << "\n";
            break; // stop early
        }
    }

    // Print even numbers using continue
    for (int i = 1; i <= 10; ++i) {
        if (i % 2 == 1) {
            continue; // skip odd numbers
        }
        std::cout << i << " ";
    }
    std::cout << "\n\n";

    // --- Range-Based for Loop ---
    std::cout << "--- Range-Based for Loop ---\n";

    std::string name = "Ada";
    for (char ch : name) {
        std::cout << "[" << ch << "]";
    }
    std::cout << "\n\n";

    // --- Nested Loops ---
    std::cout << "--- Nested Loops ---\n";

    int rows = 3;
    int cols = 5;

    for (int r = 0; r < rows; ++r) {
        for (int c = 0; c < cols; ++c) {
            std::cout << '*';
        }
        std::cout << "\n";
    }
    std::cout << "\n";

    // --- Infinite Loop with Exit ---
    std::cout << "--- Infinite Loop with break ---\n";

    int attempts = 0;
    while (true) {
        std::cout << "Attempt " << attempts << "\n";
        if (++attempts == 3) {
            break; // exit after 3 tries
        }
    }

    std::cout << "Finished all demos.\n";
    return 0;
}
