using namespace std;

#include <iostream>
#include <format>
#include <print>

// Define variables
int myInt = 45;
long long myLongInt = 2147483648L; // this value is too large for int. Use l or L to define a long integer value
float myFloat = 3.4e37F;  // use f or F when defining a float value
double myDouble = 3.4e40; // this value is too large for float

string myName = "Stephen";
auto myHomeTown = "Warner Robins";
auto myHomeState = "Georgia";

unsigned char myBinary = 0B10001111;
unsigned char binaryOne = 0B00000001;


int main() {
    cout << "Version " << __cplusplus << "\n";
    cout << "This is my floating point variable: " << myFloat << "\n";
    cout << "This is my double floating point variable: " << myDouble << "\n";
    cout << "Hello, my name is " << myName << ".\n";

    cout << "I live in " << myHomeTown << ", " << myHomeState << ".\n";
    // or (C++ 20)
    string outputMsg = std::format("I live in {}, {}.\n", myHomeTown, myHomeState);
    cout << outputMsg;
    // or (C++ 23)
    std::print("I live in {}, {}.\n", myHomeTown, myHomeState);

    // Assignment operators:
    myInt += 10; //  equivalent to myInt = myInt +10. myInt is now 55
    myInt *= 2;  //  equivalent to myInt = myInt * 2. result is 110
    myInt -= 10; //  equivalent to myInt = myInt - 10. result is now 100
    myInt /= 2;  //  equivalent to myInt = myInt / 2. result is now 50
    cout << "myInt is " << myInt << ".\n";

    // Binary operators
    // Use std::hex to change number base to hexadecimal and static_cast operator to convert myBinary to int
    cout << "My binary variable is " << hex << uppercase << static_cast<int>(myBinary) << ".\n";
    // 0B10001111 AND 0B0000001 equals 0B00000001:
    unsigned int result = myBinary & binaryOne;
    cout << "AND result is " << hex << uppercase << static_cast<int>(result) << ".\n";
    // 0B10001111 OR 0B0000001 equals 0B10001111:
    result = myBinary | binaryOne;
    cout << "OR result is " << hex << uppercase << static_cast<int>(result) << ".\n";
    // 0B10001111 XOR 0B0000001 equals 0B10001110:
    result = myBinary ^ binaryOne;
    cout << "XOR result is " << hex << uppercase << static_cast<int>(result) << ".\n";

    // if statement
    auto make = "Chevrolet";
    auto color = "red";
    if (make == "Chevrolet") {
        cout << "I drive a Chevy.\n";
    }
    if (make == "Chevrolet") {
        cout << "I drive a Chevy.\n";
    }
    else {
        cout << "I drive a make other than Chevy.\n";
    }
    // use && for AND
    if (make == "Chevrolet" && color == "red") {
        cout << "I drive a red Chevy.\n";
    }
    else {
        cout << "I drive a car other than a red Chevy.\n";
    }
    // use || for OR
    if (make == "Chevrolet" || color == "red") {
        cout << "I drive a red Chevy, a Chevy of a different color, or red car other than a Chevy.\n";
    }
    else {
        cout << "I drive a car that is not any of the above.\n";
    }
    // switch statement
    char myChar = 'A';
    switch (myChar) {
    case 'A':
        cout << "The value is A.\n";
        break;
    case 'B':
        cout << "The value is B.\n";
        break;
    case 'C':
        cout << "The value is C.\n";
        break;
    default:
        cout << "The value is some other value.\n";
    }
    // loops
    string fruits[] = { "Apples", "Oranges", "Pears", "Bananas" };
    // for loop
    int nbrOfItems = sizeof(fruits) / sizeof(fruits[0]);
    cout << "Printing array that has " << nbrOfItems << " items using a for loop.\n";
    for (string fruit : fruits) {
        cout << fruit << "\n";
    }
    cout << "Printing array that has " << nbrOfItems << " items using a for loop with break after \"Oranges\" has been printed.\n";
    for (string fruit : fruits) {
        cout << fruit << "\n";
        if (fruit == "Oranges") {
            break;
        }
    }
    cout << "Printing array that has " << nbrOfItems << " items using a for loop with continue to skip over \"Pears\".\n";
    for (string fruit : fruits) {
        if (fruit == "Pears") {
            continue;
        }
        cout << fruit << "\n";
    }
    cout << "Printing array that has " << nbrOfItems << " items using a \"classic\" for loop.\n";
    for (int i = 0; i < nbrOfItems; i++) {
        cout << fruits[i] << "\n";
    }
    int index = 0;
    cout << "Printing array that has " << nbrOfItems << " items using a while loop.\n";
    // while loop
    while (index < nbrOfItems) {
        cout << fruits[index] << "\n";
        index++;
    }
    // do while loop
    cout << "Printing array that has " << nbrOfItems << " items using a do while loop.\n";
    index = 0;
    do {
        cout << fruits[index] << "\n";
        index++;
    } while (index < nbrOfItems);

}

