#include <iostream>
#include <string>

// Example enum for the final section
enum class GameOption { NewGame, LoadGame, Quit };

int main() {
    // --- Booleans and Conditions ---
    int age = 20;
    bool isAdult = age >= 18;
    bool hasID = true;
    bool canEnter = isAdult && hasID;

    std::cout << "Can enter? " << std::boolalpha << canEnter << "\n\n";

    // Short-circuit example
    int x = 0;
    if (x != 0 && 10 / x > 2) { // second part won’t run if x == 0
        std::cout << "No division by zero!\n";
    }

    // --- The if Statement ---
    if (age >= 18) {
        std::cout << "Welcome! You are an adult.\n";
    }
    std::cout << "Done.\n\n";

    // --- if ... else ---
    int temp = 72;
    if (temp > 85) {
        std::cout << "It’s hot.\n";
    } 
    else {
        std::cout << "It’s comfortable.\n";
    }
    std::cout << "\n";

    // --- else if (Multiple Branches) ---
    int score = 86;
    if (score >= 90) {
        std::cout << "Grade: A\n";
    }
    else if (score >= 80) {
        std::cout << "Grade: B\n";
    }
    else if (score >= 70) {
        std::cout << "Grade: C\n";
    }
    else if (score >= 60) {
        std::cout << "Grade: D\n";
    }
    else {
        std::cout << "Grade: F\n";
    }
    std::cout << "\n";

    // --- Blocks and Scope ---
    int number = 4;
    if (number % 2 == 0) {
        std::string kind = "even";
        std::cout << number << " is " << kind << "\n";
    }
    // kind no longer exists here
    std::cout << "\n";

    // --- Combining Conditions ---
    bool hasTicket = true;
    bool isMember = false;

    if (hasTicket || isMember) {
        std::cout << "You may enter.\n";
    }

    int y = 5;
    if (y > 0 && y % 2 == 1) {
        std::cout << "y is a positive odd number.\n";
    }

    bool isReady = false;
    if (!isReady) {
        std::cout << "Not ready yet.\n";
    }
    std::cout << "\n";

    // --- Comparing Strings and Characters ---
    char grade = 'A';
    if (grade == 'A') {
        std::cout << "Excellent!\n";
    }

    std::string color = "red";
    if (color == "red") {
        std::cout << "Stop.\n";
    }
    else if (color == "green") {
        std::cout << "Go.\n";
    }
    else {
        std::cout << "Caution.\n";
    }
    std::cout << "\n";

    // --- The switch Statement ---
    int option = 2;
    switch (option) {
        case 0:
            std::cout << "New game\n";
            break;
        case 1:
            std::cout << "Load game\n";
            break;
        case 2:
            std::cout << "Quit\n";
            break;
        default:
            std::cout << "Unknown option\n";
            break;
    }
    std::cout << "\n";

    // --- Grouped Cases ---
    char ch = 'A';
    switch (ch) {
        case 'A':
        case 'E':
        case 'I':
        case 'O':
        case 'U':
        case 'a':
        case 'e':
        case 'i':
        case 'o':
        case 'u':
            std::cout << ch << " is a vowel.\n";
            break;
        default:
            std::cout << ch << " is a consonant or other character.\n";
            break;
    }
    std::cout << "\n";

    // --- Enums with switch ---
    GameOption choice = GameOption::LoadGame; // could also use: auto choice = GameOption::LoadGame;

    switch (choice) {
    case GameOption::NewGame:
        std::cout << "Starting a new game...\n";
        break;
    case GameOption::LoadGame:
        std::cout << "Loading saved game...\n";
        break;
    case GameOption::Quit:
        std::cout << "Exiting game.\n";
        break;
    default:
        std::cout << "Unknown option.\n";
        break;
    }

    return 0;
}