#include <iostream>
#include <format>
#include <string>

int main() {
    // Basic variables
    int myInt = 42;
    std::string myCity = "Warner Robins";
    std::string itemDescription = "Garden Hose";
    int itemLength = 25;
    float itemPrice = 24.99F;
    float discount = 5.4567F;

    // Basic formatting
    std::string basic = std::format("My integer: {}, My city: {}", myInt, myCity);
    std::cout << basic << "\n\n";

    // Advanced formatting
    std::cout << std::format(
        "The item is a {:>4} foot {:<15} that costs ${:.2f}.\n\n",
        itemLength, itemDescription, itemPrice
    );

    // Alignment examples
    std::cout << "_____________________\n";
    std::cout << std::format("{:<20}\n", itemDescription); // left
    std::cout << std::format("{:>20}\n", itemDescription); // right
    std::cout << std::format("{:^20}\n\n", itemDescription); // center

    // Width and fill character
    std::cout << std::format("{:*<20}\n", itemDescription); // left with '*'
    std::cout << std::format("{:*>20}\n", itemDescription); // right with '*'
    std::cout << std::format("{:*^20}\n\n", itemDescription); // center with '*'

    // Additional specifiers examples

    int number = 42;
    int negative = -42;
    float pi = 3.14159;

    // Sign specifier
    std::cout << std::format("{:+d}, {:+d}\n", number, negative); // always show sign

    // Zero-padding
    std::cout << std::format("{:05d}\n", number); // pad with zeros to width 5

    // Type specifiers
    std::cout << std::format("Decimal: {}, Hex: {:x}, Binary: {:b}\n", number, number, number);

    // Float precision and fixed-point
    std::cout << std::format("Pi rounded to 3 decimals: {:.3f}\n\n", pi);

    // Float precision 
    std::cout << std::format("Original price: ${}\n", itemPrice);
    std::cout << std::format("Discounted price: ${:.2f}\n\n", itemPrice - discount); // 2 decimal places

    // Combining text and variables 
    std::cout << std::format(
        "Shopping Info: Item '{}', Length: {} ft, Price: ${:.2f}, Discount: ${:.2f}\n\n",
        itemDescription, itemLength, itemPrice, discount
    );
    std::cout << "End of Demo!\n"; 

    return 0;
}
