#include <iostream>
#include <string>
#include <string_view>

int main() {
    // std::string Example
    std::string myString = "This is a C++ string";
    std::cout << "My String: " << myString << "\n";

    // substring using substr()
    std::cout << "myString.substr(5, 2): " << myString.substr(5, 2) << "\n";

    // accessing single character
    std::cout << "myString[0]: " << myString[0] << "\n";

    // string concatenation
    std::string anotherString = myString + " with concatenation!";
    std::cout << anotherString << "\n";

    // string size and empty check
    std::cout << "Size of myString: " << myString.size() << "\n";
    std::cout << "Is myString empty? " << (myString.empty() ? "Yes" : "No") << "\n\n";

    // std::string_view Example
    std::string fullName = "Stephen Withrow";
    size_t lastNameIndex = fullName.find("Withrow");

    // create a view over the last name
    std::string_view myLastName(fullName.c_str() + lastNameIndex, 7);
    std::cout << "My last name using string_view: " << myLastName << "\n\n";

    // Combining string and string_view
    std::string greeting = "Hello";
    std::string_view greetView = greeting;
    std::cout << "Original greeting: " << greeting << "\n";
    std::cout << "View of greeting: " << greetView << "\n\n";

    // More examples
    std::string hello = "Hello";
    std::string world = "World";

    // concatenation
    std::string message = hello + " " + world;
    std::cout << "Concatenated message: " << message << "\n";

    // substring using string_view
    std::string_view helloView(hello.c_str(), hello.size());
    std::cout << "Substring view of hello: " << helloView << "\n";

    return 0;
}
