// StringFormatting.cpp 
//

#include <iostream>
#include <format>

int main() {
    int myInt = 42;
    std::string myCity = "Warner Robins";
    std::string formatted = std::format("My integer: {}, My city: {}", myInt, myCity);
    std::cout << formatted << "\n";

    std::string itemDescription = "Garden Hose";
    int itemLength = 25;
    float itemPrice = 24.99F;
    std::cout << std::format("The item is a {} foot {} that costs ${}.\n", itemLength, itemDescription, itemPrice);

    // left, right, and center alignment
    std::cout << "********************\n";
    std::cout << std::format("{:<20}\n", itemDescription);
    std::cout << std::format("{:>20}\n", itemDescription);
    std::cout << std::format("{:^20}\n", itemDescription);
}
