#include <iostream>
#include <array>
#include <algorithm> // for sort()
#include <string>

int main() {
    // Modern Arrays in C++
    std::array<int, 3> nums = {1, 2, 3};
    std::cout << "First element: " << nums[0] << "\n";
    std::cout << "Array size: " << nums.size() << "\n\n";

    std::array<std::string, 4> fruits = {"Apples", "Bananas", "Pears", "Oranges"};
    std::cout << "Second fruit (safe access): " << fruits.at(1) << "\n\n";

    // Example (C-style vs Modern)
    std::string fruits_C[] = {"Apples", "Bananas", "Pears", "Oranges"};

    std::cout << "Iterating through C-style array:\n";
    for (int i = 0; i < 4; i++) {
        std::cout << fruits_C[i] << "\n";
    }

    std::cout << "\nIterating through std::array:\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }
    std::cout << "\n";

    // Accessing Elements
    std::cout << "Accessing elements:\n";
    std::cout << "Using []: " << fruits[2] << "\n";
    std::cout << "Using .at(): " << fruits.at(2) << "\n\n";

    // Using std::array Functions
    std::array<int, 5> numbers = {5, 2, 9, 1, 3};
    std::sort(numbers.begin(), numbers.end());

    std::cout << "Sorted numbers: ";
    for (int n : numbers) {
        std::cout << n << " ";
    }
    std::cout << "\n\n";

    // Creating an Empty std::array
    std::array<int, 5> emptyArray{}; // all elements initialized to 0
    emptyArray[0] = 10;
    std::cout << "First element of empty array: " << emptyArray[0] << "\n";
    std::cout << "Default-initialized element: " << emptyArray[1] << "\n\n";

    std::cout << "Demo complete.\n";
}
