#include <iostream>
#include <cstring> // For strcpy(), strncpy(), strcat(), strncat()

int main() {
    // 1. Memory Basics: Bits, Bytes, and Words
    std::cout << "=== Memory Basics ===\n";
    std::cout << "A 'bit' is the smallest unit of data (0 or 1).\n" ;
    std::cout << "A 'byte' is 8 bits (enough to store one character).\n" ;
    std::cout << "A 'word' is usually 64 bits (8 bytes) on modern computers.\n\n";
    std::cout << "=== Example: Size of Data Types ===\n";
    std::cout << "Size of char: " << sizeof(char) << " byte\n";
    std::cout << "Size of int: " << sizeof(int) << " bytes\n";
    std::cout << "Size of double: " << sizeof(double) << " bytes\n\n";

    // 2. Working with C-style Arrays
    std::cout << "=== C-style Arrays ===\n";
    int numbers[5] = {10, 20, 30, 40, 50}; // Array of 5 integers
    std::cout << "The array contains: \n";
    for (int i = 0; i < 5; i++) {
        std::cout << numbers[i] << " \n";
    }
    std::cout << "Remember: array indexes start at 0 and end at 4.\n";
    std::cout <<"Accessing an index outside this range can cause errors.\n\n";

    // 3. Exploring C-style Strings
    std::cout << "=== C-style Strings ===\n";
    char greeting[] = "Hello"; // A string is a char array ending with '\0'
    std::cout << "Greeting: " << greeting << "\n";
    std::cout << "Each character is stored in memory, ending with a '\\0' symbol.\n\n";

    // 4. String Copy Functions
    std::cout << "=== strcpy() and strncpy() ===\n";
    char source[] = "Good Morning";
    char destination1[20];
    char destination2[6];

    // strcpy() copies the entire string
    strcpy(destination1, source);
    std::cout << "Using strcpy(): " << destination1 <<"\n";

    // strncpy() copies only part of string (safer)
    strncpy(destination2, source, 5);
    destination2[5] = '\0'; // Always add '\0' manually
    std::cout << "Using strncpy(): " << destination2 << "\n\n";

    // 5. String Concatenation Functions
    std::cout << "=== strcat() and strncat() ===\n";
    char text[30] = "Good ";
    char word[] = "Evening";

    // strcat() joins two strings
    strcat(text, word);
    std::cout << "Using strcat(): " << text << "\n";

    // strncat() joins part of a string safely
    char text2[30] = "Good ";
    strncat(text2, word, 4);
    std::cout << "Using strncat(): " << text2 << "\n\n";

    // 6. Summary
    std::cout << "=== Summary ===\n";
    std::cout << "- Arrays store multiple items of the same type.\n";
    std::cout << "- C-style strings are character arrays ending with '\\0'.\n";
    std::cout << "- strcpy() and strcat() can be unsafe if space is too small.\n";
    std::cout << "- strncpy() and strncat() are safer since they limit copied data.\n";
    std::cout << "- Always check your array size to avoid memory errors.\n\n";
    std::cout << "End of Demo. Try changing the text or numbers to experiment!\n";

    return 0;
}
